/*
 
This sample project illustrates how use the Amyuni PDF Converter with C#
 
You can download a fully functional evaluation version of the product from the link below:
 
 http://www.amyuni.com/en/developer/pdfconverter
 
 */

using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Printing;
using System.IO;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;
using CDIntfEx;
using Microsoft.Office.Core;
using Microsoft.Office.Interop.PowerPoint;
using Microsoft.Office.Interop.Word;
using Application = System.Windows.Forms.Application;
using Button = System.Windows.Forms.Button;
using Document = CDIntfEx.Document;
using Font = System.Drawing.Font;
using Label = System.Windows.Forms.Label;
using TextBox = System.Windows.Forms.TextBox;
using _Application = Microsoft.Office.Interop.Excel._Application;

namespace PDFConverter
{
    /// <inheritdoc />
    /// <summary>
    ///     Summary description for Form1.
    /// </summary>
    public class Form1 : Form
    {
        private const int SNoPrompt = 0x01;
        private const int Concat = 0x04;
        private const int LExportToRtf = 0x8000000;

        ////////////////////////////////////////////////////////
        //create PDF printer constants	
        private const string PdfPrinter = "Amyuni PDF Converter";



        private const string StrActivationCode =
            "07EFCDAB0100010025AFF1801CB9441306C5739F7D452154D8833B9CECBA2ADE79E3762A69FFC354528A5F4A5811BE3204A0A439F5BA";

        //Evaluation Codes of the Amyuni PDF Suite
        private const string StrLicenseTo = "Amyuni PDF Converter Evaluation";
        private const int SUseFileName = 0x02;

        /// <summary>
        ///     Required designer variable.
        /// </summary>
        private readonly Container _components = null;

        private Button _btnAppend;
        private Button _btnBatchConvert;
        private Button _btnChangeProperties;
        private Button _btnEncrypt;

        private Button _btnExportTiff;
        private Button _btnExportToExcel;
        private Button _btnExportToHtml;
        private Button _btnExportToJpeg;
        private Button _btnExportToRtf;
        private Button _btnPrintExcel;
        private Button _btnPrintExportToExcel;
        private Button _btnPrintPdfDoc;
        private Button _btnPrintPowerPoint;
        private Button _btnPrintRtf;
        private Button _btnPrintText;
        private Button _btnPrintTff;
        private Button _btnPrintWord;
        private Button _btnThread;

        private Label _label1;
        private Label _label2;
        private Label _label3;
        private Label _lblPagePrint;
        private PrintDocument _printDocument1;
        private TabControl _tabControl1;
        private TabPage _tabPage1;
        private TabPage _tabPage2;
        private TabPage _tabPage3;
        private TabPage _tabPage4;
        private TextBox _txtActivationCode;
        private TextBox _txtLicenseTo;
        private TextBox _txtPrinterName;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            _txtLicenseTo.Text = StrLicenseTo;
            _txtActivationCode.Text = StrActivationCode;
            _txtPrinterName.Text = PdfPrinter;

            _printDocument1.PrintController = new StandardPrintController();
        }

        public void AmyuniBeginPage(int nJobId, int hDc)
        {
            _lblPagePrint.Text = "Page printed";
        }

        /// <summary>
        ///     Append Docs
        /// </summary>
        private void btnAppend_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Appending PDF documents";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdfDoc = new Document();
            pdfDoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);
            try
            {
                var bResult = pdfDoc.OpenEx(requiredPath + "\\Source_Docs\\fivepages.pdf", "");
                if (bResult)
                {
                    var bResultAppend = pdfDoc.Append(requiredPath + "\\Source_Docs\\logo.pdf");

                    if (bResultAppend)
                    {
                        var bResultSave = pdfDoc.Save(requiredPath + "Resulting_Docs\\append.pdf");
                        if (bResultSave)
                            MessageBox.Show("Append Error Save");
                        else
                            return;
                    }
                    else
                    {
                        MessageBox.Show("Append Error Append");
                    }
                }
                else
                {
                    MessageBox.Show("Append Error Open ");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Append Error Crash");
            }

            _lblPagePrint.Text = "Finished Appending PDF documents";
        }

        /// <summary>
        ///     The BatchConvert method converts a number of files to PDF, RTF, HTML, Excel or JPeg formats in batch mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnBatchConvert_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "....";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter); //Amyuni PDF Converter

            pdf.SetDefaultPrinter();
            pdf.DefaultDirectory = requiredPath + "\\Resulting_Docs\\";

            pdf.FileNameOptionsEx = SNoPrompt;

            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            /*The Document Converter printer should be configured with the destination file name and all other 
             * options before calling this function. The printer should also be set as default printer. 
             * This function launches the application that is associated with a specific file and issues a print 
             * command to convert the document.*/

            pdf.BatchConvert(requiredPath + "\\Source_Docs\\*.doc");

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptions = 0;

            _lblPagePrint.Text = "BatchConvert";
        }

        private void btnChangeProperties_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Change PDF documents Attributes";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdFdoc = new Document();
            try
            {
                pdFdoc.Open(requiredPath + "\\Source_Docs\\fivepages.pdf");
                pdFdoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);
                pdFdoc.Author = "Bill Smith";
                pdFdoc.Subject = "Test Doc";
                pdFdoc.KeyWords = "add keywords";
                pdFdoc.Creator = "my product";
                pdFdoc.Title = "this is the document title";
                pdFdoc.Save(requiredPath + "Resulting_Docs\\ChangeProperties.pdf");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            _lblPagePrint.Text = "Finished Changing PDF documents Attributes";
        }

        /// <summary>
        ///     Encrypt document at run-time
        ///     The Encryption property can be used to password protect a PDF document and restrict
        ///     users to viewing, modifying or evenprinting the document.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEncrypt_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter);
            pdf.DefaultFileName = requiredPath + "Resulting_Docs\\encrypt.pdf";
            pdf.SetDefaultPrinter();

            /*////////////////////////////////////////////////////////////
            'Permission                         Permission value
            'Enable Printing                        - 64 + 4
            'Enable document modification           - 64 + 8
            'Enable copying text and graphics       - 64 + 16
            'Enable adding and changing notes       - 64 + 32
            'To combine multiple options, use -64 plus the values 4, 8, 16 or 32. E.g. to enable */

            //1 = 40-bit encryption
            //2 = 128-bit encryption

            pdf.Encryption = 2;
            pdf.OwnerPassword = "aaaaaa";
            pdf.UserPassword = "bbbbbb";
            pdf.Permissions = -64 + 4;
            pdf.SetDefaultConfig();

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;
            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            //Print something
            _printDocument1.Print();

            //Reset
            pdf.Encryption = 0;
            pdf.SetDefaultConfig();

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptions = 0;

            _lblPagePrint.Text = "Document Encrypted!";
        }

        /// <summary>
        ///     Export PDF document into TIFF
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportTiff_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Exporting to TIFF";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdFdoc = new Document();
            try
            {
                pdFdoc.SetLicenseKey(StrLicenseTo, StrActivationCode);
                pdFdoc.OpenEx(requiredPath + "\\Source_Docs\\fivepages.pdf", "");

                pdFdoc.Optimize(2);
                pdFdoc.ExportToTIFF(requiredPath + "\\Resulting_Docs\\exporttotif.tif",
                    acTiffExportOptions.acTiffExportOptionCCITTHigh);

                MessageBox.Show("Document Converted", "Amyuni Sample", MessageBoxButtons.OKCancel,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Amyuni Sample", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);
            }

            _lblPagePrint.Text = "Finished Exporting to TIFF";
        }

        /// <summary>
        ///     Export existing PDF into XLS format
        /// </summary>
        private void btnExportToExcel_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Exporting to XLS";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdFdoc = new Document();
            try
            {
                pdFdoc.Open(requiredPath + "\\Source_Docs\\fivepages.pdf");
                pdFdoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);

                /*  'No optimization 0
                    'Line optimization (Recommended) 1
                    'Paragraph optimization 2
                */
                pdFdoc.Optimize(1);
                pdFdoc.ExportToEXCEL(requiredPath+ "\\Resulting_Docs\\\from_c_sharp.xls",
                    acExcelExportOptions.acExcelExportOptionMultipleSheets);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            _lblPagePrint.Text = $"Finished Exporting to XLS";
        }

        /// <summary>
        ///     Export existing PDF document into HTML format
        /// </summary>
        private void btnExportToHtml_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = $"Exporting to HTML";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdFdoc = new Document();

            try
            {
                pdFdoc.OpenEx(requiredPath + "Source_Docs\\fivepages.pdf", "");

                pdFdoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);
                pdFdoc.Optimize(1);

                pdFdoc.ExportToHTML(requiredPath + "Resulting_Docs\\exporttohtml.htm",
                    acHtmlExportOptions.acHtmlExportOptionSinglePage);

                MessageBox.Show("Document Converted", "Amyuni Sample", MessageBoxButtons.OKCancel,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Amyuni Sample", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);
            }

            _lblPagePrint.Text = "Finished Exporting to HTML";
        }

        /// <summary>
        ///     Export PDF document into JPEG image
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToJPEG_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Exporting to JPEG";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdFdoc = new Document();
            try
            {
                pdFdoc.OpenEx(requiredPath + "Source_Docs\\fivepages.pdf", "");
                pdFdoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);

                /*  'No optimization 0
                    'Line optimization (Recommended) 1
                    'Paragraph optimization 2
                */
                pdFdoc.Optimize(1);

                pdFdoc.ExportToJPEG(requiredPath + "Resulting_Docs\\exporttojpg.jpg",
                    acJPegExportOptions.acJPegExportOptionMedium);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            _lblPagePrint.Text = "Finished Exporting to JPEG";
        }

        /// <summary>
        ///     Export PDF document to RTF
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToRtf_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Exporting to RTF....";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            //create Document object
            var pdFdoc = new Document();

            try
            {
                //Need to set License information
                pdFdoc.SetLicenseKey(StrLicenseTo, StrActivationCode);

                //Open PDF file to convert into RTF format
                pdFdoc.OpenEx(requiredPath + "Source_Docs\\fivepages.pdf", "");

                /*
                 Optimization Level OptimizeLevel value
                 No optimization                    0
                 Line optimization (Recommended)    1
                 Paragraph optimization              2
                 */
                pdFdoc.Optimize(1);

                /*
                    acRtfExportOptionAdvancedRTF Using frames to position objects 0x0000
                    acRtfExportOptionFullRTF Text, Graphics, and images with no frames 0x0001
                    acRtfExportOptionRTFText Formatted text only 0x0002
                    acRtfExportOptionText Simple, non-formated text 0x0003
                 */

                pdFdoc.ExportToRTF(requiredPath + "Resulting_Docs\\exporttortf.rtf",
                    acRtfExportOptions.acRtfExportOptionAdvancedRTF, false);

                MessageBox.Show("Document Converted", "Amyuni Sample", MessageBoxButtons.OKCancel,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Amyuni Sample", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);
            }

            _lblPagePrint.Text = "Finished Exporting to RTF";
        }

        /// <summary>
        ///     Print XLS file
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintExcel_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Going to Print Excel Docs";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter);
            pdf.DefaultFileName = requiredPath + "Resulting_Docs\\print_excel.pdf";
            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName + Concat; //1 + 2 + 4;

            pdf.SetDefaultPrinter();
            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            PrintExcel(requiredPath + "Source_Docs\\test.xls");

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptions = 0;
            pdf.DriverEnd();

            _lblPagePrint.Text = "..Printed Excel Docs";
        }

        /// <summary>
        ///     Print into XLS format
        /// </summary>
        private void btnPrintExportToExcel_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "....";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter); //Amyuni PDF Converter

            pdf.DefaultFileName = requiredPath + "Source_Docs\\print_excel.pdf";

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;

            //PDF.SetPrinterParamInt("EXCEL MultiSheets",18);   ' // Single Excel sheet with comma separator
            //PDF.SetPrinterParamInt("EXCEL MultiSheets", 17);    ' // MultiSheets Excel sheet
            //PDF.SetPrinterParamInt("EXCEL MultiSheets",19;)    ' // MultiSheets Excel sheet with comma separator
            pdf.SetPrinterParamInt("EXCEL MultiSheets", 16);

            pdf.SetDefaultPrinter();

            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);
            //Print something
            _printDocument1.Print();

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptionsEx = 0;
            pdf.DriverEnd();

            _lblPagePrint.Text = "Printed into XLS";
        }

        /// <summary>
        ///     Print existing PDF document
        ///     The Print method can be used to print a PDF document to a hardware printer. It is also used to print
        ///     multiple pages on a single sheet of paper.This method is available only in the professional
        ///     version of the Amyuni PDF Converter product.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintPDFDoc_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Printing PDF document";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdfDoc = new Document();

            try
            {
                pdfDoc.OpenEx(requiredPath + "Source_Docs\\fivepages.pdf", "");

                pdfDoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);

                //Parameters
                //PrinterName
                //[in] Name of printer as it shows in the printers control panel. 
                //If this parameter is left empty, the document will print to the default printer
                //StartPage
                //[in] Page number from which to start printing. The index of the first page is 1
                //EndPage
                //[in] Page number at which to stop printing
                //Copies
                //[in] Number of copies to print the document

                pdfDoc.Print("", 1, pdfDoc.PageCount(), 1);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            _lblPagePrint.Text = "Finished Printing PDF document";
        }

        /// <summary>
        ///     Print PPT Docs
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintPowerPoint_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Going to Print PowerPoint Docs";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter);
            pdf.DefaultFileName = pdf.DefaultFileName = requiredPath + "Resulting_Docs\\PowerPoint.pdf";

            pdf.SimPostscript = true;
            pdf.SetDefaultConfig();

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;

            pdf.EnablePrinter(StrLicenseTo, StrActivationCode);
            PrintPowerPoint(requiredPath + "Source_Docs\\powerpoint.ppt");

            pdf.FileNameOptions = 0;

            _lblPagePrint.Text = "..Printed Excel Docs";
        }

        /// <summary>
        ///     Print a document into RTF format
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintRTF_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "";
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter); //Amyuni PDF Converter

            /*			PDF.VerticalMargin = 0;
                        PDF.HorizontalMargin = 0;
                        PDF.SetDefaultConfig ();
            */
            pdf.DefaultFileName = requiredPath + "Source_Docs\\print_rtf.pdf";

            /*/////////////////////////////////////////////////////////////
            'RTF Format Integer Option for formatting the RTF output
            '0  Advanced RTF
            '1  Full RTF
            '2  Formatted Text
            '3  Non-formatted Text Only
            'Example: PDF.PrinterParamInt("RTF Format") = 1

            '////////////////////////////////////////////////////////////
            'Use Tabs Integer Option to replace tabs by spaces
            '0  Do not replace
            '1  Replace
            'Example: PDF.PrinterParamInt("Use Tabs") = 0
            */

            pdf.SetPrinterParamInt("RTF Format", 1);
            pdf.SetPrinterParamInt("Use Tabs", 0);

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName + LExportToRtf;

            pdf.SetDefaultPrinter();
            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            //Print something
            _printDocument1.Print();

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptionsEx = 0;
            pdf.DriverEnd();

            _lblPagePrint.Text = "Printed into RTF";
        }

        /// <summary>
        ///     This code snippet illustrates how to print
        ///     from the Amyuni PDF Converter using the printer object
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintText_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Printing text";


            //Declare object
            var pdf = new CDIntfEx.CDIntfEx();

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            //Initialize printer
            pdf.DriverInit(PdfPrinter);

            pdf.DefaultFileName = requiredPath + "\\Resulting_Docs\\print_text.pdf";

            //Change some printer settings
            pdf.PaperSize = 1; // letter
            pdf.Orientation = 1; // portrait
            pdf.HorizontalMargin = 0;
            pdf.VerticalMargin = 0;
            pdf.Resolution = 1200;
            pdf.ImageOptions = 1; // no duplicates

            //need to call this to apply changes
            pdf.SetDefaultConfigEx();

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;

            var currentPrinter = _printDocument1.PrinterSettings.PrinterName;

            _printDocument1.PrinterSettings.PrinterName = PdfPrinter;

            //This function needs to be called right before each print job
            pdf.EnablePrinter(StrLicenseTo, StrActivationCode);

            //Print something
            _printDocument1.Print();

            pdf.FileNameOptions = 0;
            _printDocument1.PrinterSettings.PrinterName = currentPrinter;

            _lblPagePrint.Text = "Finished Printing text";
        }

        /// <summary>
        ///     Print document into TIFF format
        /// </summary>
        private void btnPrintTFF_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "....";
            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter); //Amyuni PDF Converter

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            pdf.DefaultFileName = requiredPath + "Resulting_Docs\\print_tiff.pdf";

            /*///////////////////////////////////////
            'Custom parameters for the TIFF Converter:
            'Parameter Type Description Values
            'TIFF Resolution: Integer Image resolution at which the document
            'is converted to JPeg
            '0  75 DPI
            '1  150 DPI
            '2  300 DPI
            '3  600 DPI
            'TIFF Options: Integer TIFF compression level.
            '0  No TIFF Output
            '16  TIFF output with no compression
            '26  TIFF output with CCITT Fax Compression
            '17 to 25 JPEG Compression values. Note: Not supported by all tiff viewers
            '(17 = 1 to 25 = 9)
            ///////////////////////////////////////////*/
            pdf.SetPrinterParamInt("TIFF Options", 26);
            pdf.SetPrinterParamInt("TIFF Resolution", 1);

            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;

            pdf.SetDefaultPrinter();
            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            //Print something
            _printDocument1.Print();

            pdf.RestoreDefaultPrinter();
            pdf.FileNameOptionsEx = 0;
            pdf.DriverEnd();

            _lblPagePrint.Text = "Printed into TIFF";
        }

        /// <summary>
        ///     Print MsWord Docs
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrintWord_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Going to Print MsWord Docs";

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            //Declare object
            var pdf = new CDIntfEx.CDIntfEx();

            //Initialize Printer
            pdf.DriverInit(PdfPrinter);

            //set FileName for resulting PDF document
            pdf.DefaultFileName = requiredPath + "Resulting_Docs\\print_word.pdf";
            pdf.FileNameOptionsEx = SNoPrompt + SUseFileName;

            pdf.EnablePrinter(_txtLicenseTo.Text, _txtActivationCode.Text);

            //Print to Word
            PrintToMsWord(requiredPath + "Source_Docs\\batchconvert.doc");

            pdf.FileNameOptions = 0;
            pdf.DriverEnd();
            _lblPagePrint.Text = "..Printed MsWord Docs";
        }

        /// <summary>
        ///     This code snippet uses Threading to illstrutate the
        ///     Lock/Unlock functionality of the PDF Converter.
        ///     The Lock function can be used in multi-threading situations to avoid conflicts between
        ///     multiple applications or multiple threads requesting simultaneous access the Converter products.
        ///     The CDIntf library uses the registry to interact with the printer drivers.
        ///     This can cause conflicts when multiple applications use CDIntf to access the printer drivers.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnThread_Click(object sender, EventArgs e)
        {
            _lblPagePrint.Text = "Start Threading";
            var demoThread =
                new Thread(thread_printing);

            demoThread.Start();
            _lblPagePrint.Text = "End Threading";
        }

        /// <summary>
        ///     Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                _components?.Dispose();
            }

            base.Dispose(disposing);
        }


        #region Windows Form Designer generated code

        /// <summary>
        ///     Required method for Designer support - do not modify
        ///     the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this._tabControl1 = new System.Windows.Forms.TabControl();
            this._tabPage1 = new System.Windows.Forms.TabPage();
            this._btnThread = new System.Windows.Forms.Button();
            this._btnBatchConvert = new System.Windows.Forms.Button();
            this._btnEncrypt = new System.Windows.Forms.Button();
            this._btnPrintPdfDoc = new System.Windows.Forms.Button();
            this._btnPrintText = new System.Windows.Forms.Button();
            this._tabPage2 = new System.Windows.Forms.TabPage();
            this._btnPrintPowerPoint = new System.Windows.Forms.Button();
            this._btnPrintExcel = new System.Windows.Forms.Button();
            this._btnPrintWord = new System.Windows.Forms.Button();
            this._tabPage3 = new System.Windows.Forms.TabPage();
            this._btnPrintExportToExcel = new System.Windows.Forms.Button();
            this._btnPrintTff = new System.Windows.Forms.Button();
            this._btnExportToExcel = new System.Windows.Forms.Button();
            this._btnExportToJpeg = new System.Windows.Forms.Button();
            this._btnPrintRtf = new System.Windows.Forms.Button();
            this._btnExportToHtml = new System.Windows.Forms.Button();
            this._btnExportTiff = new System.Windows.Forms.Button();
            this._btnExportToRtf = new System.Windows.Forms.Button();
            this._tabPage4 = new System.Windows.Forms.TabPage();
            this._btnChangeProperties = new System.Windows.Forms.Button();
            this._btnAppend = new System.Windows.Forms.Button();
            this._txtActivationCode = new System.Windows.Forms.TextBox();
            this._txtLicenseTo = new System.Windows.Forms.TextBox();
            this._txtPrinterName = new System.Windows.Forms.TextBox();
            this._label3 = new System.Windows.Forms.Label();
            this._label2 = new System.Windows.Forms.Label();
            this._label1 = new System.Windows.Forms.Label();
            this._printDocument1 = new System.Drawing.Printing.PrintDocument();
            this._lblPagePrint = new System.Windows.Forms.Label();
            this._tabControl1.SuspendLayout();
            this._tabPage1.SuspendLayout();
            this._tabPage2.SuspendLayout();
            this._tabPage3.SuspendLayout();
            this._tabPage4.SuspendLayout();
            this.SuspendLayout();
            // 
            // tabControl1
            // 
            this._tabControl1.Controls.Add(this._tabPage1);
            this._tabControl1.Controls.Add(this._tabPage2);
            this._tabControl1.Controls.Add(this._tabPage3);
            this._tabControl1.Controls.Add(this._tabPage4);
            this._tabControl1.Location = new System.Drawing.Point(0, 136);
            this._tabControl1.Name = "_tabControl1";
            this._tabControl1.SelectedIndex = 0;
            this._tabControl1.Size = new System.Drawing.Size(568, 240);
            this._tabControl1.TabIndex = 15;
            // 
            // tabPage1
            // 
            this._tabPage1.Controls.Add(this._btnThread);
            this._tabPage1.Controls.Add(this._btnBatchConvert);
            this._tabPage1.Controls.Add(this._btnEncrypt);
            this._tabPage1.Controls.Add(this._btnPrintPdfDoc);
            this._tabPage1.Controls.Add(this._btnPrintText);
            this._tabPage1.Location = new System.Drawing.Point(4, 22);
            this._tabPage1.Name = "_tabPage1";
            this._tabPage1.Size = new System.Drawing.Size(560, 214);
            this._tabPage1.TabIndex = 0;
            this._tabPage1.Text = "Print Text";
            // 
            // btnThread
            // 
            this._btnThread.Location = new System.Drawing.Point(196, 16);
            this._btnThread.Name = "_btnThread";
            this._btnThread.Size = new System.Drawing.Size(144, 24);
            this._btnThread.TabIndex = 6;
            this._btnThread.Text = "Threading";
            this._btnThread.Click += new System.EventHandler(this.btnThread_Click);
            // 
            // btnBatchConvert
            // 
            this._btnBatchConvert.Location = new System.Drawing.Point(16, 136);
            this._btnBatchConvert.Name = "_btnBatchConvert";
            this._btnBatchConvert.Size = new System.Drawing.Size(144, 24);
            this._btnBatchConvert.TabIndex = 4;
            this._btnBatchConvert.Text = "Batch Convert";
            this._btnBatchConvert.Click += new System.EventHandler(this.btnBatchConvert_Click);
            // 
            // btnEncrypt
            // 
            this._btnEncrypt.Location = new System.Drawing.Point(16, 96);
            this._btnEncrypt.Name = "_btnEncrypt";
            this._btnEncrypt.Size = new System.Drawing.Size(144, 24);
            this._btnEncrypt.TabIndex = 3;
            this._btnEncrypt.Text = "Print Encrypt";
            this._btnEncrypt.Click += new System.EventHandler(this.btnEncrypt_Click);
            // 
            // btnPrintPDFDoc
            // 
            this._btnPrintPdfDoc.Location = new System.Drawing.Point(16, 56);
            this._btnPrintPdfDoc.Name = "_btnPrintPdfDoc";
            this._btnPrintPdfDoc.Size = new System.Drawing.Size(144, 24);
            this._btnPrintPdfDoc.TabIndex = 2;
            this._btnPrintPdfDoc.Text = "Print PDF doc";
            this._btnPrintPdfDoc.Click += new System.EventHandler(this.btnPrintPDFDoc_Click);
            // 
            // btnPrintText
            // 
            this._btnPrintText.Location = new System.Drawing.Point(16, 16);
            this._btnPrintText.Name = "_btnPrintText";
            this._btnPrintText.Size = new System.Drawing.Size(144, 24);
            this._btnPrintText.TabIndex = 1;
            this._btnPrintText.Text = "Print Text";
            this._btnPrintText.Click += new System.EventHandler(this.btnPrintText_Click);
            // 
            // tabPage2
            // 
            this._tabPage2.Controls.Add(this._btnPrintPowerPoint);
            this._tabPage2.Controls.Add(this._btnPrintExcel);
            this._tabPage2.Controls.Add(this._btnPrintWord);
            this._tabPage2.Location = new System.Drawing.Point(4, 22);
            this._tabPage2.Name = "_tabPage2";
            this._tabPage2.Size = new System.Drawing.Size(560, 214);
            this._tabPage2.TabIndex = 1;
            this._tabPage2.Text = "Print Office Products";
            this._tabPage2.Visible = false;
            // 
            // btnPrintPowerPoint
            // 
            this._btnPrintPowerPoint.Location = new System.Drawing.Point(16, 80);
            this._btnPrintPowerPoint.Name = "_btnPrintPowerPoint";
            this._btnPrintPowerPoint.Size = new System.Drawing.Size(144, 24);
            this._btnPrintPowerPoint.TabIndex = 2;
            this._btnPrintPowerPoint.Text = "Print PowerPoint";
            this._btnPrintPowerPoint.Click += new System.EventHandler(this.btnPrintPowerPoint_Click);
            // 
            // btnPrintExcel
            // 
            this._btnPrintExcel.Location = new System.Drawing.Point(16, 48);
            this._btnPrintExcel.Name = "_btnPrintExcel";
            this._btnPrintExcel.Size = new System.Drawing.Size(144, 24);
            this._btnPrintExcel.TabIndex = 1;
            this._btnPrintExcel.Text = "Print MsExcel";
            this._btnPrintExcel.Click += new System.EventHandler(this.btnPrintExcel_Click);
            // 
            // btnPrintWord
            // 
            this._btnPrintWord.Location = new System.Drawing.Point(16, 16);
            this._btnPrintWord.Name = "_btnPrintWord";
            this._btnPrintWord.Size = new System.Drawing.Size(144, 24);
            this._btnPrintWord.TabIndex = 0;
            this._btnPrintWord.Text = "Print MsWord";
            this._btnPrintWord.Click += new System.EventHandler(this.btnPrintWord_Click);
            // 
            // tabPage3
            // 
            this._tabPage3.Controls.Add(this._btnPrintExportToExcel);
            this._tabPage3.Controls.Add(this._btnPrintTff);
            this._tabPage3.Controls.Add(this._btnExportToExcel);
            this._tabPage3.Controls.Add(this._btnExportToJpeg);
            this._tabPage3.Controls.Add(this._btnPrintRtf);
            this._tabPage3.Controls.Add(this._btnExportToHtml);
            this._tabPage3.Controls.Add(this._btnExportTiff);
            this._tabPage3.Controls.Add(this._btnExportToRtf);
            this._tabPage3.Location = new System.Drawing.Point(4, 22);
            this._tabPage3.Name = "_tabPage3";
            this._tabPage3.Size = new System.Drawing.Size(560, 214);
            this._tabPage3.TabIndex = 2;
            this._tabPage3.Text = "Export Modules";
            // 
            // btnPrintExportToExcel
            // 
            this._btnPrintExportToExcel.Location = new System.Drawing.Point(384, 96);
            this._btnPrintExportToExcel.Name = "_btnPrintExportToExcel";
            this._btnPrintExportToExcel.Size = new System.Drawing.Size(144, 24);
            this._btnPrintExportToExcel.TabIndex = 10;
            this._btnPrintExportToExcel.Text = "Print ExportToExcel";
            this._btnPrintExportToExcel.Click += new System.EventHandler(this.btnPrintExportToExcel_Click);
            // 
            // btnPrintTFF
            // 
            this._btnPrintTff.Location = new System.Drawing.Point(384, 56);
            this._btnPrintTff.Name = "_btnPrintTff";
            this._btnPrintTff.Size = new System.Drawing.Size(144, 24);
            this._btnPrintTff.TabIndex = 9;
            this._btnPrintTff.Text = "PrintTIFF";
            this._btnPrintTff.Click += new System.EventHandler(this.btnPrintTFF_Click);
            // 
            // btnExportToExcel
            // 
            this._btnExportToExcel.Location = new System.Drawing.Point(8, 136);
            this._btnExportToExcel.Name = "_btnExportToExcel";
            this._btnExportToExcel.Size = new System.Drawing.Size(144, 24);
            this._btnExportToExcel.TabIndex = 8;
            this._btnExportToExcel.Text = "Export To Excel";
            this._btnExportToExcel.Click += new System.EventHandler(this.btnExportToExcel_Click);
            // 
            // btnExportToJPEG
            // 
            this._btnExportToJpeg.Location = new System.Drawing.Point(8, 72);
            this._btnExportToJpeg.Name = "_btnExportToJpeg";
            this._btnExportToJpeg.Size = new System.Drawing.Size(144, 24);
            this._btnExportToJpeg.TabIndex = 7;
            this._btnExportToJpeg.Text = "Export to JPEG";
            this._btnExportToJpeg.Click += new System.EventHandler(this.btnExportToJPEG_Click);
            // 
            // btnPrintRTF
            // 
            this._btnPrintRtf.Location = new System.Drawing.Point(384, 16);
            this._btnPrintRtf.Name = "_btnPrintRtf";
            this._btnPrintRtf.Size = new System.Drawing.Size(144, 24);
            this._btnPrintRtf.TabIndex = 6;
            this._btnPrintRtf.Text = "Print RTF";
            this._btnPrintRtf.Click += new System.EventHandler(this.btnPrintRTF_Click);
            // 
            // btnExportToHtml
            // 
            this._btnExportToHtml.Location = new System.Drawing.Point(8, 104);
            this._btnExportToHtml.Name = "_btnExportToHtml";
            this._btnExportToHtml.Size = new System.Drawing.Size(144, 24);
            this._btnExportToHtml.TabIndex = 5;
            this._btnExportToHtml.Text = "Export To Html";
            this._btnExportToHtml.Click += new System.EventHandler(this.btnExportToHtml_Click);
            // 
            // btnExportTiff
            // 
            this._btnExportTiff.Location = new System.Drawing.Point(8, 40);
            this._btnExportTiff.Name = "_btnExportTiff";
            this._btnExportTiff.Size = new System.Drawing.Size(144, 24);
            this._btnExportTiff.TabIndex = 3;
            this._btnExportTiff.Text = "Export to TIFF";
            this._btnExportTiff.Click += new System.EventHandler(this.btnExportTiff_Click);
            // 
            // btnExportToRtf
            // 
            this._btnExportToRtf.Location = new System.Drawing.Point(8, 8);
            this._btnExportToRtf.Name = "_btnExportToRtf";
            this._btnExportToRtf.Size = new System.Drawing.Size(144, 24);
            this._btnExportToRtf.TabIndex = 2;
            this._btnExportToRtf.Text = "Export to RTF";
            this._btnExportToRtf.Click += new System.EventHandler(this.btnExportToRtf_Click);
            // 
            // tabPage4
            // 
            this._tabPage4.Controls.Add(this._btnChangeProperties);
            this._tabPage4.Controls.Add(this._btnAppend);
            this._tabPage4.Location = new System.Drawing.Point(4, 22);
            this._tabPage4.Name = "_tabPage4";
            this._tabPage4.Size = new System.Drawing.Size(560, 214);
            this._tabPage4.TabIndex = 3;
            this._tabPage4.Text = "Document Object";
            // 
            // btnChangeProperties
            // 
            this._btnChangeProperties.Location = new System.Drawing.Point(16, 61);
            this._btnChangeProperties.Name = "_btnChangeProperties";
            this._btnChangeProperties.Size = new System.Drawing.Size(136, 23);
            this._btnChangeProperties.TabIndex = 2;
            this._btnChangeProperties.Text = "Change Doc Properties";
            this._btnChangeProperties.Click += new System.EventHandler(this.btnChangeProperties_Click);
            // 
            // btnAppend
            // 
            this._btnAppend.Location = new System.Drawing.Point(16, 16);
            this._btnAppend.Name = "_btnAppend";
            this._btnAppend.Size = new System.Drawing.Size(136, 23);
            this._btnAppend.TabIndex = 0;
            this._btnAppend.Text = "Append";
            this._btnAppend.Click += new System.EventHandler(this.btnAppend_Click);
            // 
            // txtActivationCode
            // 
            this._txtActivationCode.Location = new System.Drawing.Point(112, 58);
            this._txtActivationCode.Name = "_txtActivationCode";
            this._txtActivationCode.ReadOnly = true;
            this._txtActivationCode.Size = new System.Drawing.Size(408, 20);
            this._txtActivationCode.TabIndex = 14;
            // 
            // txtLicenseTo
            // 
            this._txtLicenseTo.Location = new System.Drawing.Point(112, 34);
            this._txtLicenseTo.Name = "_txtLicenseTo";
            this._txtLicenseTo.ReadOnly = true;
            this._txtLicenseTo.Size = new System.Drawing.Size(408, 20);
            this._txtLicenseTo.TabIndex = 13;
            // 
            // txtPrinterName
            // 
            this._txtPrinterName.Location = new System.Drawing.Point(112, 10);
            this._txtPrinterName.Name = "_txtPrinterName";
            this._txtPrinterName.ReadOnly = true;
            this._txtPrinterName.Size = new System.Drawing.Size(408, 20);
            this._txtPrinterName.TabIndex = 12;
            // 
            // label3
            // 
            this._label3.Location = new System.Drawing.Point(8, 58);
            this._label3.Name = "_label3";
            this._label3.Size = new System.Drawing.Size(88, 16);
            this._label3.TabIndex = 11;
            this._label3.Text = "Activation Code:";
            // 
            // label2
            // 
            this._label2.Location = new System.Drawing.Point(8, 34);
            this._label2.Name = "_label2";
            this._label2.Size = new System.Drawing.Size(96, 16);
            this._label2.TabIndex = 10;
            this._label2.Text = "License To:";
            // 
            // label1
            // 
            this._label1.Location = new System.Drawing.Point(8, 10);
            this._label1.Name = "_label1";
            this._label1.Size = new System.Drawing.Size(88, 16);
            this._label1.TabIndex = 9;
            this._label1.Text = "Printer Name:";
            // 
            // printDocument1
            // 
            this._printDocument1.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler(this.printDocument1_PrintPage);
            // 
            // lblPagePrint
            // 
            this._lblPagePrint.AutoSize = true;
            this._lblPagePrint.Font = new System.Drawing.Font("Microsoft Sans Serif", 15F,
                System.Drawing.FontStyle.Bold,
                System.Drawing.GraphicsUnit.Point, ((byte) (0)));
            this._lblPagePrint.Location = new System.Drawing.Point(15, 90);
            this._lblPagePrint.Name = "_lblPagePrint";
            this._lblPagePrint.Size = new System.Drawing.Size(143, 25);
            this._lblPagePrint.TabIndex = 25;
            this._lblPagePrint.Text = "Printer Status";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(568, 390);
            this.Controls.Add(this._lblPagePrint);
            this.Controls.Add(this._tabControl1);
            this.Controls.Add(this._txtActivationCode);
            this.Controls.Add(this._txtLicenseTo);
            this.Controls.Add(this._txtPrinterName);
            this.Controls.Add(this._label3);
            this.Controls.Add(this._label2);
            this.Controls.Add(this._label1);
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "Form1";
            this.Text = "Amyuni PDF Converter Sample";
            this._tabControl1.ResumeLayout(false);
            this._tabPage1.ResumeLayout(false);
            this._tabPage2.ResumeLayout(false);
            this._tabPage3.ResumeLayout(false);
            this._tabPage4.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();
        }

        #endregion

        /// <summary>
        ///     The main entry point for the application.
        /// </summary>
        [STAThread]
        private static void Main()
        {
            Application.Run(new Form1());
        }

        private void printDocument1_PrintPage(object sender, PrintPageEventArgs e)
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var text = "Amyuni Technologies";
            var printFont = new Font
                ("Monotype Corsiva", 35, FontStyle.Italic);

            // Draw the content.
            e.Graphics.DrawString(text, printFont,
                Brushes.Black, 10, 10);

            var img = Image.FromFile(requiredPath + "\\Source_Docs\\Desert.jpg");

            //print image
            var imgRect = new RectangleF(50, 300, 400, 400);
            e.Graphics.DrawImage(img, imgRect);
        }

        /// <summary>
        ///     Print XLS documents
        /// </summary>
        /// <param name="strFileName"></param>
        public void PrintExcel(string strFileName)
        {
            //Start Excel and open test doc

            var oPath = strFileName;

            _Application oExcel = new Microsoft.Office.Interop.Excel.Application
            {
                Visible = false
            };
            //oExcel.ActivePrinter = PDFprinter;

            var wbExcel = oExcel.Workbooks.Open(
                oPath,
                Type.Missing, Type.Missing, Type.Missing, Type.Missing,
                Type.Missing, Type.Missing, Type.Missing, Type.Missing,
                Type.Missing, Type.Missing, Type.Missing, Type.Missing,
                Type.Missing, Type.Missing);

            wbExcel.PrintOut(
                Missing.Value, //From
                Missing.Value, //To
                1, //Copies
                Missing.Value, //Preview
                Missing.Value, //ActivePrinter
                Missing.Value, //PrinToFile
                Missing.Value, //Collate
                Missing.Value //,PrToFileName
            );

            wbExcel.Close(false, //SaveChanges
                Missing.Value, //FileName
                Missing.Value //RouteWorkbook
            );
        }

        /// <summary>
        ///     Print PPT docs
        /// </summary>
        /// <param name="strFileName"></param>
        public void PrintPowerPoint(string strFileName)
        {
            var errorMessage = "Error: ";
            Microsoft.Office.Interop.PowerPoint._Application objApp = new Microsoft.Office.Interop.PowerPoint.Application();
            try
            {
                //Create a new presentation 
                var objPresSet = objApp.Presentations;

                _Presentation objPres = objPresSet.Open(strFileName,
                    MsoTriState.msoFalse, MsoTriState.msoTrue,
                    MsoTriState.msoFalse);

                //store active printer
                var pptActivePrinter = objPres.PrintOptions.ActivePrinter;
                objPres.PrintOptions.ActivePrinter = PdfPrinter;

                objPres.PrintOut(1, 1, "", 1, MsoTriState.msoFalse);

                //restore active printer
                objPres.PrintOptions.ActivePrinter = pptActivePrinter;

                //Close the presentation
                objPres.Close();
                objApp.Quit();
            }
            catch (Exception theException)
            {
                errorMessage = string.Concat(errorMessage, theException.Message);
                errorMessage = string.Concat(errorMessage, " Line: ");
                errorMessage = string.Concat(errorMessage, theException.Source);

                MessageBox.Show(errorMessage, "Error");
            }
        }

        public void PrintToMsWord(string strFileName)
        {
            object oMissing = Missing.Value;

            //Start Word and open the test document.
            Microsoft.Office.Interop.Word._Application oWord = new Microsoft.Office.Interop.Word.Application();
            oWord.Visible = false;

            //Save active printer
            var strSaveActivePrinter = oWord.ActivePrinter;

            //assign word a printer
            oWord.ActivePrinter = PdfPrinter;
            object oPath = strFileName;

            _Document oDoc = oWord.Documents.Open(ref oPath,
                ref oMissing, ref oMissing, ref oMissing,
                ref oMissing, ref oMissing, ref oMissing,
                ref oMissing, ref oMissing,
                ref oMissing, ref oMissing, ref oMissing, ref oMissing,
                ref oMissing, ref oMissing, ref oMissing);

            //print it
            object xcopies = 1;
            object xpt = false;
            object oFalse = false;

            oDoc.PrintOut(ref xpt, ref oMissing, ref oMissing,
                ref oMissing, ref oMissing, ref oMissing, ref oMissing, ref
                xcopies, ref oMissing, ref oMissing, ref oMissing, ref
                oMissing, ref oMissing, ref oMissing, ref oMissing, ref
                oMissing, ref oMissing, ref oMissing);

            //close the document
            oDoc.Close(ref oFalse, ref oMissing, ref oMissing);

            oWord.Options.SaveNormalPrompt = false;
            oWord.Options.SavePropertiesPrompt = false;
            oWord.NormalTemplate.Saved = true;

            //restore active printer
            oWord.ActivePrinter = strSaveActivePrinter;

            //close word
            oWord.Quit(ref oFalse, ref oMissing, ref oMissing);

            //Drop our reference to the COM object
            Marshal.ReleaseComObject(oWord);
        }

        public void PrintWaterMark()
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var oDoc = new Document();
            oDoc.SetLicenseKey(_txtLicenseTo.Text, _txtActivationCode.Text);
            oDoc.Open(requiredPath + "\\Source_Docs\\fivepages.pdf");
            var nPageCount = oDoc.PageCount();

            oDoc.Print("", 1, nPageCount, 1);
        }

        /// <summary>
        ///     Lock/Unlock Functions
        /// </summary>
        private void thread_printing()
        {
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                Path.GetDirectoryName(
                    Assembly.GetExecutingAssembly().Location))));

            var pdf = new CDIntfEx.CDIntfEx();
            pdf.DriverInit(PdfPrinter);

            //Need to use distinct doc names
            var docTitle = "amy" + DateTime.UtcNow.Millisecond;
            _printDocument1.DocumentName = docTitle;

            pdf.Lock(docTitle);

            pdf.SetDocFileProps(docTitle, 3, "", requiredPath + "\\Resulting_Docs\\" + docTitle + ".pdf");

            pdf.EnablePrinter(StrLicenseTo, StrActivationCode);

            //Print something
            _printDocument1.Print();
            pdf.Unlock(docTitle, 1000);
        }
    }
}